﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.IO;
using System.Runtime.InteropServices;

namespace FleetPC_9
{
    public partial class Form1 : Form
    {
        private bool check_32 = false;
        private bool check_64 = false;

        #region InOut資料庫

        [DllImport("inpout32.dll")]
        private static extern UInt32 IsInpOutDriverOpen();

        [DllImport("inpout32.dll")]
        private static extern void Out32(UInt16 PortAddress, UInt32 Data);

        [DllImport("inpout32.dll")]
        //private static extern char Inp32(UInt16 PortAddress);
        private static extern UInt32 Inp32(UInt16 PortAddress);

        [DllImport("inpout32.dll")]
        private static extern void DlPortWritePortUshort(short PortAddress, ushort Data);

        [DllImport("inpout32.dll")]
        private static extern ushort DlPortReadPortUshort(short PortAddress);

        [DllImport("inpout32.dll")]
        private static extern void DlPortWritePortUlong(int PortAddress, uint Data);

        [DllImport("inpout32.dll")]
        private static extern uint DlPortReadPortUlong(int PortAddress);

        [DllImport("inpout32.dll")]
        private static extern bool IsXP64Bit();

        [DllImport("inpout32.dll")]
        private static extern int Opendriver(bool bX64);

        [DllImport("inpout32.dll")]
        private static extern void Closedriver();

        [DllImport("inpoutx64.dll")]
        private static extern bool GetPhysLong(ref int PortAddress, ref uint Data);

        [DllImport("inpoutx64.dll")]
        private static extern bool SetPhysLong(ref int PortAddress, ref uint Data);

        [DllImport("inpoutx64.dll", EntryPoint = "IsInpOutDriverOpen")]
        private static extern UInt32 IsInpOutDriverOpen_x64();

        [DllImport("inpoutx64.dll", EntryPoint = "Out32")]
        private static extern void Out32_x64(UInt16 PortAddress, UInt32 Data);

        [DllImport("inpoutx64.dll", EntryPoint = "Inp32")]
        //private static extern char Inp32_x64(UInt16 PortAddress);
        private static extern UInt32 Inp32_x64(UInt16 PortAddress);

        [DllImport("inpoutx64.dll", EntryPoint = "DlPortWritePortUshort")]
        private static extern void DlPortWritePortUshort_x64(short PortAddress, ushort Data);

        [DllImport("inpoutx64.dll", EntryPoint = "DlPortReadPortUshort")]
        private static extern ushort DlPortReadPortUshort_x64(short PortAddress);

        [DllImport("inpoutx64.dll", EntryPoint = "DlPortWritePortUlong")]
        private static extern void DlPortWritePortUlong_x64(int PortAddress, uint Data);

        [DllImport("inpoutx64.dll", EntryPoint = "DlPortReadPortUlong")]
        private static extern uint DlPortReadPortUlong_x64(int PortAddress);

        [DllImport("inpoutx64.dll", EntryPoint = "GetPhysLong")]
        private static extern bool GetPhysLong_x64(ref int PortAddress, ref uint Data);

        [DllImport("inpoutx64.dll", EntryPoint = "SetPhysLong")]
        private static extern bool SetPhysLong_x64(ref int PortAddress, ref uint Data);

        [DllImport("inpoutx64.dll", EntryPoint = "IsXP64Bit")]
        private static extern bool IsXP64Bit_x64();

        [DllImport("inpoutx64.dll", EntryPoint = "Opendriver")]
        private static extern int Opendriver_x64(bool bX64);

        [DllImport("inpoutx64.dll", EntryPoint = "Closedriver")]
        private static extern void Closedriver_x64();

        #endregion InOut資料庫

        #region Check資料庫x64

        private void Driver_Check_x64()
        {
            uint nResult = 0;

            nResult = IsInpOutDriverOpen_x64();
            check_64 = IsXP64Bit_x64();
            if (nResult == 0)
            {
                Opendriver(check_64);
                Closedriver_x64();
            }
        }

        #endregion Check資料庫x64

        #region Check資料庫x86

        private void Driver_Check_x86()
        {
            uint nResult = 0;

            nResult = IsInpOutDriverOpen();
            check_32 = IsXP64Bit();
            if (nResult == 0)
            {
                Opendriver(check_32);
                Closedriver();
            }
        }

        #endregion Check資料庫x86

        public Form1()
        {
            InitializeComponent();
            Driver_Check_x86();
        }

        private UInt16 SMBus_Base = 0xF040;
        private UInt16 SMBus_SlaveAddress = 0x94;

        #region SMBus Function R/W

        private void SMB_Write(UInt16 SMB_Addr, UInt16 DEV_Address, UInt16 DEV_Reg, UInt16 Value) //SMBus寫入
        {
            Out32(SMB_Addr, 0xFF);                                              // Clear SMBUS Status
            Thread.Sleep(10);                                                  // Delay 10 ms (1000 is 1 Sec)
            Out32((ushort)(SMB_Addr + 0x04), DEV_Address);                      // EEPROM Address AE -Write / AF -Read
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x03), DEV_Reg);                          // EEPROM Reg Address
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x05), Value);                            // Write Data in EEPROM
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x02), 0x48);                             // Start to Send
            Thread.Sleep(10);
        }

        private UInt32 SMB_Read(UInt16 SMB_Addr, UInt16 DEV_Address, UInt16 DEV_Reg) //SMBus讀取
        {
            UInt32 Value;
            Out32(SMB_Addr, 0xFF);                                              // Clear SMBUS Status
            Thread.Sleep(10);                                                  // Delay 10 ms (1000 is 1 Sec)
            Out32((ushort)(SMB_Addr + 0x04), (ushort)(DEV_Address + 1));         // EEPROM Address AE -Write / AF -Read
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x03), DEV_Reg);                          // EEPROM Reg Address
            Thread.Sleep(10);
            Out32((ushort)(SMB_Addr + 0x02), 0x48);                             // Start to Send
            Thread.Sleep(50);
            Value = Inp32((ushort)(SMB_Addr + 0x05));                           // Read Data in EEPROM
            Thread.Sleep(10);
            return Value;
        }

        #endregion SMBus Function R/W

        #region Firmware Check

        private void Firmware_Check_Button_Click(object sender, EventArgs e)
        {
            UInt32 Firmware_version1, Firmware_version2, Firmware_version3, Firmware_version4, Firmware_version5;
            Firmware_version5 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x05);
            Firmware_version4 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x04);
            Firmware_version3 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x03);
            Firmware_version2 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x02);
            Firmware_version1 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x01);
            Firmware_Check_TextBox.Text = "V" + string.Format("{0:X}", Firmware_version1) + "." + string.Format("{0:X}", Firmware_version2) + "." + string.Format("{0:X}", Firmware_version3) + "." + string.Format("{0:X}", Firmware_version4) + "." + string.Format("{0:X}", Firmware_version5);
        }

        #endregion Firmware Check

        #region IGN Function

        private void Get_IGN_Delay_Time_Button_Click(object sender, EventArgs e)
        {
            UInt32 IGN_Hour, IGN_Min, IGN_Sec;
            IGN_Sec = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x66);
            IGN_Min = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x67);
            IGN_Hour = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x68);
            IGN_Delay_Hour_TextBox.Text = IGN_Hour.ToString();
            IGN_Delay_Min_TextBox.Text = IGN_Min.ToString();
            IGN_Delay_Sec_TextBox.Text = IGN_Sec.ToString();
        }

        private void Set_IGN_Delay_Time_Button_Click(object sender, EventArgs e)
        {
            if (int.Parse(IGN_Delay_Hour_TextBox.Text) < 0 || int.Parse(IGN_Delay_Hour_TextBox.Text) > 23)
            {
                MessageBox.Show("Hour enter:'0~23'");
                IGN_Delay_Hour_TextBox.Text = "0";
            }
            else if (int.Parse(IGN_Delay_Min_TextBox.Text) < 0 || int.Parse(IGN_Delay_Min_TextBox.Text) > 59)
            {
                MessageBox.Show("Min enter:'0~59'");
                IGN_Delay_Min_TextBox.Text = "0";
            }
            else if (int.Parse(IGN_Delay_Sec_TextBox.Text) < 0 || int.Parse(IGN_Delay_Sec_TextBox.Text) > 59)
            {
                MessageBox.Show("Sec enter:'0~59'");
                IGN_Delay_Sec_TextBox.Text = "0";
            }
            else
            {
                UInt16 IGN_Hour, IGN_Min, IGN_Sec;
                IGN_Hour = UInt16.Parse(IGN_Delay_Hour_TextBox.Text, System.Globalization.NumberStyles.Number);
                IGN_Min = UInt16.Parse(IGN_Delay_Min_TextBox.Text, System.Globalization.NumberStyles.Number);
                IGN_Sec = UInt16.Parse(IGN_Delay_Sec_TextBox.Text, System.Globalization.NumberStyles.Number);
                SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x66, IGN_Sec);
                SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x67, IGN_Min);
                SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x68, IGN_Hour);
            }
        }

        #endregion IGN Function

        #region IGN Status

        private void Ignition_Status_Button_Click(object sender, EventArgs e)
        {
            UInt32 Ignition_Status;
            Ignition_Status = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x12);                             // SMB address:0xF040; Device address: 0x94; System Status Reg:0x12

            if (Ignition_Status == 0x01)                                                 // Ignition is On
            {
                MessageBox.Show("Ignition is On (High)", "ABOX-5000 Tools V1", MessageBoxButtons.OK, MessageBoxIcon.Information);
                IGN_ON_RadioButton.Checked = true;
            }
            else if (Ignition_Status == 0x00)                                            // If bit3 = 0 --> Ignition is Off
            {
                MessageBox.Show("Ignition is Off (Low)", "ABOX-5000 Tools V1", MessageBoxButtons.OK, MessageBoxIcon.Information);
                IGN_OFF_RadioButton.Checked = true;
            }
        }

        #endregion IGN Status

        #region 3G Function

        private void Select_SIM1_Button_Click(object sender, EventArgs e)
        {
            UInt32 SIM;
            SIM = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x39);
            SIM = (SIM & 0xFE) | 0x01;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x39, (UInt16)SIM);
        }

        private void Select_SIM2_Button_Click(object sender, EventArgs e)
        {
            UInt32 SIM;
            SIM = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x39);
            SIM = SIM & 0xFE;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x39, (UInt16)SIM);
        }

        private void Reset_3G_Button_Click(object sender, EventArgs e)
        {
            UInt32 Reset_3G;
            Reset_3G = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x39);
            Reset_3G = Reset_3G & 0xFD;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x39, (UInt16)Reset_3G);
            Thread.Sleep(2000);
            Reset_3G = Reset_3G | 0x02;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x39, (UInt16)Reset_3G);
        }

        #endregion 3G Function

        #region Save value to MCU

        private void Save_MCU_Button_Click(object sender, EventArgs e)
        {
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x28, 0x02);
        }

        #endregion Save value to MCU

        #region Close Form

        private void exitButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        #endregion Close Form

        #region DO1~DO4 Set to High

        private void do1HButton_Click(object sender, EventArgs e)
        {
            UInt32 DO1;
            DO1 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO1 = DO1 | 0x01;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO1);
        }

        private void do2HButton_Click(object sender, EventArgs e)
        {
            UInt32 DO2;
            DO2 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO2 = DO2 | 0x02;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO2);
        }

        private void do3HButton_Click(object sender, EventArgs e)
        {
            UInt32 DO3;
            DO3 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO3 = DO3 | 0x04;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO3);
        }

        private void do4HButton_Click(object sender, EventArgs e)
        {
            UInt32 DO4;
            DO4 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO4 = DO4 | 0x08;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO4);
        }

        #endregion DO1~DO4 Set to High

        #region DO1~DO4 Set to Low

        private void do1LButton_Click(object sender, EventArgs e)
        {
            UInt32 DO1;
            DO1 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO1 = DO1 & 0xFE;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO1);
        }

        private void do2LButton_Click(object sender, EventArgs e)
        {
            UInt32 DO2;
            DO2 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO2 = DO2 & 0xFD;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO2);
        }

        private void do3LButton_Click(object sender, EventArgs e)
        {
            UInt32 DO3;
            DO3 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO3 = DO3 & 0xFB;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO3);
        }

        private void do4LButton_Click(object sender, EventArgs e)
        {
            UInt32 DO4;
            DO4 = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x31);
            DO4 = DO4 & 0xF7;
            SMB_Write(SMBus_Base, SMBus_SlaveAddress, 0x31, (UInt16)DO4);
        }

        #endregion DO1~DO4 Set to Low

        #region Get DI1~DI8

        private void getDiButton_Click(object sender, EventArgs e)
        {
            UInt32 DI_Value;
            DI_Value = SMB_Read(SMBus_Base, SMBus_SlaveAddress, 0x30);
            Thread.Sleep(1000);
            if ((DI_Value & 0x01) == 1)
            {
                di1HRadioButton.Checked = true;
            }
            else
            {
                di1LRadioButton.Checked = true;
            }
            if (((DI_Value >> 1) & 0x01) == 1)
            {
                di2HRadioButton.Checked = true;
            }
            else
            {
                di2LRadioButton.Checked = true;
            }
            if (((DI_Value >> 2) & 0x01) == 1)
            {
                di3HRadioButton.Checked = true;
            }
            else
            {
                di3LRadioButton.Checked = true;
            }
            if (((DI_Value >> 3) & 0x01) == 1)
            {
                di4HRadioButton.Checked = true;
            }
            else
            {
                di4LRadioButton.Checked = true;
            }
            if (((DI_Value >> 4) & 0x01) == 1)
            {
                di5HRadioButton.Checked = true;
            }
            else
            {
                di5LRadioButton.Checked = true;
            }
            if (((DI_Value >> 5) & 0x01) == 1)
            {
                di6HRadioButton.Checked = true;
            }
            else
            {
                di6LRadioButton.Checked = true;
            }
            if (((DI_Value >> 6) & 0x01) == 1)
            {
                di7HRadioButton.Checked = true;
            }
            else
            {
                di7LRadioButton.Checked = true;
            }
            if (((DI_Value >> 7) & 0x01) == 1)
            {
                di8HRadioButton.Checked = true;
            }
            else
            {
                di8LRadioButton.Checked = true;
            }
        }

        #endregion Get DI1~DI8
    }
}